﻿
/*

DECLARE @RC int
DECLARE @ID bigint
DECLARE @TruckDate datetime
DECLARE @TruckNo Nvarchar(50)
DECLARE @Weight decimal(18,0)
DECLARE @Pack int
DECLARE @Barname Nvarchar(50)
DECLARE @Serial Nvarchar(50)
DECLARE @RESULT int

--select Date, TruckNo , Weigh , Pack, BarName, BarnameSerial,* from AccSellFactorTrucks where ID=77

select @ID=ID, @TruckDate=Date, @TruckNo=TruckNo , @Weight=Weigh , @Pack=Pack, @Barname=BarName, @Serial=BarnameSerial from AccSellFactorTrucks
where ID=77
select @TruckNo
EXECUTE @RC = [dbo].[CheckSellFactorTruckDupplicate] 
	@ID
	,@TruckDate
  ,@TruckNo
  ,@Weight
  ,@Pack
  ,@Barname
  ,@Serial
  ,@RESULT OUTPUT

select @RC

*/

/****** Object:  StoredProcedure [dbo].[CreateIDList]    Script Date: 9/10/2024 10:11:41 ق.ظ ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

 CREATE PROCEDURE [dbo].[CheckSellFactorTruckDupplicate]
	@ExID as BigInt,
	@TruckDate as DateTime,
	@TruckNo as NVARCHAR(50),
	@Weight as decimal,
	@Pack as int,
	@Barname as NVARCHAR(50),
	@Serial as NVARCHAR(50),
	@RESULT int OUTPUT
AS
BEGIN
	DECLARE @ID as BIGINT
	DECLARE @Filter as NVARCHAR(max)
	DECLARE @FLAGS as NVARCHAR(1024)
	SET @Filter='ID <>' + STR(@ExID)
	select @FLAGS=TheValue from AppSetting where Name = 'Company.SellFactor.TrucksUniqueFlags'
	--YesNo, Date, TruckNo, Weight, Pack, Barname, Serial
	--print 'XX'+ Str(CHARINDEX('TruckNo',@FLAGS))
	if CHARINDEX('Date',@FLAGS) > 0
		set @Filter=@Filter+' AND [Date]= ''' + Cast(@TruckDate as nvarchar(20)) + ''''
	if CHARINDEX('TruckNo',@FLAGS) > 0
		set @Filter=@Filter+' AND TruckNo= N''' + @TruckNo + ''''
	if CHARINDEX('Weight',@FLAGS) > 0
		set @Filter=@Filter+' AND Weigh= ' + Cast(@Weight as nvarchar(20))
	if CHARINDEX('Pack',@FLAGS) > 0
		set @Filter=@Filter+' AND Pack= ' + Cast(@Pack as nvarchar(20))
	if CHARINDEX('Barname',@FLAGS) > 0
		set @Filter=@Filter+' AND Barname= N''' + @Barname + ''''
	if CHARINDEX('Serial',@FLAGS) > 0
		set @Filter=@Filter+' AND BarnameSerial= N''' + @Serial + ''''
	--SET @Filter=SUBSTRING(@Filter,5,Len(@Filter)-5)
	
	DECLARE @rowcount int
	SET @rowcount=0
	if LEN(@Filter)>5 
	BEGIN
		set @Filter = N'Select @rowcount=Count(ID) from AccSellFactorTrucks with(nolock) where ' + @Filter
		print @Filter
		exec sp_executesql  @Filter, N'@rowcount int output', @rowcount output;
	END
	--print 'Select Count(*) from AccSellFactorTrucks with(nolock) where' + @Filter
	set @RESULT=@rowcount
END
